#include "h/pll.h"
#include "h/p33FJ64GP802.h"

void initPLL(void)
{
	// configures the PLL for a 24.576Mhz Crystal...
	//PLLFBD=36;			// choose PLLDIV=36 (*38) PLL Stage
	//CLKDIV=0x0004;		// choose PLLPOST=0 (/2) and PLLPRE=4 (/6)
	// configures the PLL for a 10MHz Crystal
	PLLFBD=30;				// choose PLLDIV=30 (*32) PLL Stage
	CLKDIV=0;				// choose PLLPOST=0 (/2) and PLLPRE=0 (/2)
	// Clock switch to incorporate PLL
	__builtin_write_OSCCONH(0x00);		// Initiate Clock Switch to FRC without PLL (NOSC=0b000)
	__builtin_write_OSCCONL(0x01);		// Start clock switching
	// Wait for PLL to lock
	while(OSCCONbits.LOCK!=1);
	__builtin_write_OSCCONH(0x03);		// select crystal with PLL
	__builtin_write_OSCCONL(0x01);		// Start Clock Switching
}

